# Vespucci 13.0 Highlights

2019-04-04

### Support for multi-polygon, improved area and turn restriction rendering and improved styling configuration

Vespucci will now render multipolygons, the standard style for this and some common area types is to have a thick border on the inside of the polygons similar to other editors. In principle it is possible to use a fill style, however particularly large multipolygons will typically have some non-downloaded members which will lead to rendering artifacts.

Turn-restrictions will be indicated with an icon near the via node or way.

The style configuration has been substantially revamped to allow cascading styles (and by that requiring less typing) and matching on arbitrary tags or tag combinations, further some previously hard wired constants are now exposed for configuration, for example the maximum zoom level at which icons are still displayed.

Further improvements:

* Improve riverbank rendering by making "oneway" arrows configurable.
* Add casing support for ways.

As previously the style format remains undocumented outside of the source code and the [configuration files themselves](https://raw.githubusercontent.com/MarcusWolschon/osmeditor4android/master/src/main/assets/Color-round-profile.xml)

### Support applying osmChange format files

osmChange format files can now be applied to loaded data. This makes the functionality to save such files much more useful, for example potential problems can be inspected and fixed in the saved files and then re-applied without having to use JOSM.

### Add support for MapSplit tiled OSM data

MapSplit sources contain original OSM data in PBF format tiles. These files can be configured as read-only data sources and be used for editing on the go when there is no expectation of network coverage or there is only slow Internet connectivity available. While it was previously possible to simply load larger areas directly in to memory, this has a large impact on performance that is avoided by being able to load data for smaller areas on demand.

MapSplit sources can be configured in the via the "Configuration" menu item for the data layer in the layer control, edit or add an entry, and click the folder icon on the "Read.only API URL". 

Notes:

* edits naturally still need to be either uploaded or saved locally for later upload
* currently there is no online service for obtaining data in this format, so you will need to extract and convert data for the areas that you are interested in yourself: [MapSplit repository](https://github.com/simonpoole/mapsplit/). 
* currently the sources are completely static on device, so your edits will not be reflected, there is some work under way to changes this.
* offline background imagery can be used in Vespucci in MBTiles format.

### Support reading PBF format OSM data files

Vespucci can now read OSM data from files in PBF format, the most popular binary format for OSM data. 

## Miscellaneous

* Add preference for map screen orientation.
* Support filtering name suggestions by country/region.
* Support draft comment and source tags and add review_requested.
* Improve pinch/spread zoom behaviour.
* Avoid floating point binary representation issues on input and output.
* Add confirmation modal before deleting stored GPX data.
* Validate and highlight unconnected highway end nodes that probably should be connected (required distance can be configured in the validation preferences).
* Validate and highlight untagged ways that are not a relation member and relations.
* Item lists for API, Preset and Geocoder configuration now have a menu button that can be used instead of a long press, further API entries can now be copied.
* "Go to element" button in the element info dialog when started from the upload dialog.
* Support for reading presets from on-device files.
* MapRoulette tasks are now disabled by default on new installs to stop users without MapRoulette accounts from fixing them "by accident" and then not knowing what to do.

# Upgrading from previous versions

* As the saved state file format changed for version 13.0, please complete any edits before upgrading if your current version is older.
* As the format of the style configuration has changed you will need to adapt any custom styles you have produced.

# Known problems

* the documentation is out of date.
* For known problems with this build please see [our issue tracker](https://github.com/MarcusWolschon/osmeditor4android/issues)

